<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

use Proxim\ObjectModel;

/**
 * PrePaperPreview
 */
class PrePaperPreview extends ObjectModel
{
	/** @var $id PrePaperPreview ID */
	public $id;

	/** @var int prepaper_id */
	public $prepaper_id;

	/** @var string name */
	public $name;
	
	/** @var int size */
	public $size = 0;
	
	/** @var string source */
	public $source;
	
	/** @var string extension */
    public $extension;
    
    /** @var int order */
	public $order = 0;

	/** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'prepaper_preview',
        'primary' => 'prepaper_preview_id',
        'fields' => array(
			'prepaper_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'name' => array('type' => self::TYPE_STRING),
			'size' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
			'source' => array('type' => self::TYPE_STRING),
            'extension' => array('type' => self::TYPE_STRING),
            'order' => array('type' => self::TYPE_STRING),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
		)
	);

	/**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
	}
}
