<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

use Proxim\ObjectModel;

/**
 * PrePaperPayment
 */
class PrePaperPayment extends ObjectModel
{
	/** @var $id PrePaperPayment ID */
	public $id;

	/** @var int prepaper_id */
    public $prepaper_id;
    
    /** @var int customer_id */
	public $customer_id;

	/** @var string payment_method */
	public $payment_method;
	
	/** @var string payment_token */
	public $payment_token;
	
	/** @var float amount */
    public $amount = 0;
    
    /** @var bool is_paid */
	public $is_paid = 0;
	
	/** @var string paid_at */
	public $paid_at;

	/** @var string date_upd */
	public $date_upd;
	
	/** @var string date_add */
	public $date_add;

	/**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'prepaper_payment',
        'primary' => 'prepaper_payment_id',
        'fields' => array(
            'prepaper_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
			'customer_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'required' => true),
            'payment_method' => array('type' => self::TYPE_STRING, 'size' => 255, 'required' => true),
            'payment_token' => array('type' => self::TYPE_STRING, 'size' => 255),
            'amount' => array('type' => self::TYPE_FLOAT, 'validate' => 'isPrice'),
            'is_paid' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'paid_at' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
			'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
		)
	);
}
