<!-- PeachPayments -->
<div class="tab-pane" id="peachpayments">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fas fa-info-circle fa-2x"></i>
        </div>
        <div class="text">
            To start using PeachPayment, you'll need to create an account at <a target="_blank" href="https://www.peachpayments.com/">PeachPayment</a><br>
            Check the documentation for more help
        </div>
    </div>

    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updatePeachPaymentsSettings">
        <input type="hidden" name="site_id" value="{$peachpaymentsConfiguration.SITE_ID}"/>
        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">PeachPayment Enabled</div> 
                <div class="form-text">Enable payments via PeachPayment</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="peachpayments_enabled"> 
                    <input type="checkbox" name="peachpayments_enabled" id="peachpayments_enabled"  {if $peachpaymentsConfiguration.PEACHPAYMENTS_ENABLED == '1'}checked="checked"{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Default</div> 
                <div class="form-text">Make it the default payment method of the site</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="default_method_enabled"> 
                    <input type="checkbox" name="default_method_enabled" id="default_method_enabled"  {if $peachpaymentsConfiguration.PAYMENT_METHOD_DEFAULT == 'peachpayments'}checked="checked"{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>
     
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                PeachPayment Mode
            </label>
            <div class="col-sm-9">
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="peachpayments_mode" id="peachpayments_live" {if $peachpaymentsConfiguration.PEACHPAYMENTS_MODE == 'live'}checked{/if} value="live">
                    <label for="peachpayments_live">Live</label>
                </div>
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="peachpayments_mode" id="peachpayments_sandbox" {if $peachpaymentsConfiguration.PEACHPAYMENTS_MODE == 'sandbox'}checked{/if} value="sandbox">
                    <label for="peachpayments_sandbox">Sandbox</label>    
                </div>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Entity ID</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="peachpayments_entity_id" id="peachpayments_entity_id" maxlength="255" value="{$peachpaymentsConfiguration.PEACHPAYMENTS_ENTITY_ID}">
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Access Token</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="peachpayments_access_token" id="peachpayments_access_token" maxlength="255" value="{$peachpaymentsConfiguration.PEACHPAYMENTS_ACCESS_TOKEN}">
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- PeachPayments -->