<a href="/overview" class="d-none" data-ajax="/overview" id="dashboardRedirectLink"></a>

<div class="nk-block-head nk-block-head-sm">
    <div class="nk-block-between">
        <div class="nk-block-head-content">
            <h3 class="nk-block-title page-title">Dashboard</h3>
        </div>
        <div class="nk-block-head-content">
            <div class="toggle-wrap nk-block-tools-toggle">
                <a href="#" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="pageMenu"><em class="icon ni ni-more-v"></em></a>
                <div class="toggle-expand-content" data-content="pageMenu">
                    <ul class="nk-block-tools g-3">
                        <li>
                            <a href="javascript:void(0);" class="btn btn-white btn-dim btn-outline-light" id="dashboard-daterangepicker">
                                <em class="d-none d-sm-inline icon ni ni-calender-date"></em><span>
                                {if !empty($range) && in_array($range, array('Today','Yesterday','This Week','This Month','Last Month','This Year'))}
                                    <span>{$range}</span>
                                {elseif !empty($start) && !empty($end)}
                                    <span>{$range}</span>
                                {else}
                                    <span>This Year</span>
                                {/if}
                                <em class="dd-indc icon ni ni-chevron-right"></em>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div><!-- .nk-block-head-content -->
    </div>
</div>

{if $user.is_admin}
    <div class="nk-block">
        <div class="row g-gs">
            <div class="col-md-6">
                <div class="card is-dark h-100">
                    <div class="nk-ecwg nk-ecwg1">
                        <div class="card-inner">
                            <div class="card-title-group">
                                <div class="card-title">
                                    <h6 class="title">Total Sales</h6>
                                </div>
                            </div>
                            <div class="data">
                                <div class="amount">{formatPrice($insights['total_sales'])}</div>
                                {if !$hasRange}
                                    <div class="info">
                                        <strong>{formatPrice($insights.previous_month_sales)}</strong> in last month
                                    </div>
                                {/if}
                            </div>
                            {if !$hasRange}
                                <div class="data">
                                    <h6 class="sub-title">This month so far</h6>
                                    <div class="data-group">
                                        <div class="amount">
                                            {formatPrice($insights.current_month_sales)}
                                        </div>
                                        <div class="info text-right">
                                            <span class="change {if $insights.pct_change_monthly_sales <= 0}down{else}up{/if}">
                                                <em class="icon ni {if $insights.pct_change_monthly_sales <= 0}ni-arrow-long-down{else}ni-arrow-long-up{/if}"></em>{numberFormat($insights['pct_change_monthly_sales'])}%
                                            </span><br>
                                            <span>vs. last month</span>
                                        </div>
                                    </div>
                                </div>
                            {/if}
                            <h6 class="sub-title">Sales over time</h6>
                        </div><!-- .card-inner -->
                        <div class="nk-ecwg2-ck">
                            <canvas class="ecommerce-bar-chart-s1" data-type="amount" id="totalSales"></canvas>
                        </div>
                    </div><!-- .nk-ecwg -->
                </div><!-- .card -->
            </div><!-- .col --> 
            
            <div class="col-md-6">
                <div class="card h-100">
                    <div class="nk-ecwg nk-ecwg2">
                        <div class="card-inner">
                            <div class="card-title-group mt-n1">
                                <div class="card-title">
                                    <h6 class="title">Total orders</h6>
                                </div>
                            </div>
                            <div class="data">
                                <div class="amount">{numberFormat($insights.total_orders)}</div>
                                {if !$hasRange}
                                    <div class="info">
                                        <strong>{numberFormat($insights.previous_month_orders)}</strong> in last month
                                    </div>
                                {/if}
                            </div>
                            {if !$hasRange}
                                <div class="data">
                                    <h6 class="sub-title">This month so far</h6>
                                    <div class="data-group">
                                        <div class="amount">
                                            {numberFormat($insights.current_month_orders)}
                                        </div>
                                        <div class="info text-right">
                                            <span class="change {if $insights.pct_change_monthly_orders <= 0}down{else}up{/if}">
                                                <em class="icon ni {if $insights.pct_change_monthly_orders <= 0}ni-arrow-long-down{else}ni-arrow-long-up{/if}"></em>{numberFormat($insights['pct_change_monthly_orders'])}%
                                            </span><br>
                                            <span>vs. last month</span>
                                        </div>
                                    </div>
                                </div>
                            {/if}
                            <h6 class="sub-title">Orders over time</h6>
                        </div><!-- .card-inner -->
                        <div class="nk-ecwg2-ck">
                            <canvas class="ecommerce-bar-chart-s1" id="totalOrders"></canvas>
                        </div>
                    </div><!-- .nk-ecwg -->
                </div><!-- .card -->
            </div><!-- .col -->

            <div class="col-md-6">
                <div class="card h-100">
                    <div class="nk-ecwg nk-ecwg2">
                        <div class="card-inner">
                            <div class="card-title-group mt-n1">
                                <div class="card-title">
                                    <h6 class="title">Total Customers</h6>
                                </div>
                            </div>
                            <div class="data">
                                <div class="amount">{numberFormat($insights.total_customers)}</div>
                                {if !$hasRange}
                                    <div class="info">
                                        <strong>{numberFormat($insights.previous_month_customers)}</strong> in last month
                                    </div>
                                {/if}
                            </div>
                            {if !$hasRange}
                                <div class="data">
                                    <h6 class="sub-title">This month so far</h6>
                                    <div class="data-group">
                                        <div class="amount">
                                            {numberFormat($insights.current_month_customers)}
                                        </div>
                                        <div class="info text-right">
                                            <span class="change {if $insights.pct_change_monthly_customers <= 0}down{else}up{/if}">
                                                <em class="icon ni {if $insights.pct_change_monthly_customers <= 0}ni-arrow-long-down{else}ni-arrow-long-up{/if}"></em>{numberFormat($insights.pct_change_monthly_customers)}%
                                            </span><br>
                                            <span>vs. last month</span>
                                        </div>
                                    </div>
                                </div>
                            {/if}
                            <h6 class="sub-title">Customers over time</h6>
                        </div><!-- .card-inner -->
                        <div class="nk-ecwg2-ck">
                            <canvas class="ecommerce-bar-chart-s1" id="totalCustomers"></canvas>
                        </div>
                    </div><!-- .nk-ecwg -->
                </div><!-- .card -->
            </div><!-- .col -->

            <div class="col-md-6">
                <div class="card h-100">
                    <div class="nk-ecwg nk-ecwg2">
                        <div class="card-inner">
                            <div class="card-title-group mt-n1">
                                <div class="card-title">
                                    <h6 class="title">Total Payments</h6>
                                </div>
                            </div>
                            <div class="data">
                                <div class="amount">{formatPrice($insights.total_payments)}</div>
                                {if !$hasRange}
                                    <div class="info">
                                        <strong>{formatPrice($insights.previous_month_payments)}</strong> in last month
                                    </div>
                                {/if}
                            </div>
                            {if !$hasRange}
                                <div class="data">
                                    <h6 class="sub-title">This month so far</h6>
                                    <div class="data-group">
                                        <div class="amount">
                                            {formatPrice($insights.current_month_payments)}
                                        </div>
                                        <div class="info text-right">
                                            <span class="change {if $insights.pct_change_monthly_payments <= 0}down{else}up{/if}">
                                                <em class="icon ni {if $insights.pct_change_monthly_payments <= 0}ni-arrow-long-down{else}ni-arrow-long-up{/if}"></em>{numberFormat($insights.pct_change_monthly_payments)}%
                                            </span><br>
                                            <span>vs. last month</span>
                                        </div>
                                    </div>
                                </div>
                            {/if}
                            <h6 class="sub-title">Payments over time</h6>
                        </div><!-- .card-inner -->
                        <div class="nk-ecwg2-ck">
                            <canvas class="ecommerce-bar-chart-s1" data-type="amount" id="totalPayments"></canvas>
                        </div>
                    </div><!-- .nk-ecwg -->
                </div><!-- .card -->
            </div><!-- .col -->
        </div>

        {if $tips_enabled}
            <div class="row g-gs">
                <div class="col-xxl-6">
                    <div class="row g-gs">
                        <div class="col-lg-6 col-xxl-12">
                            <div class="card">
                                <div class="card-inner">
                                    <div class="card-title-group align-start mb-2">
                                        <div class="card-title">
                                            <h6 class="title">Tips</h6>
                                            <p>{$range} revenue from tips.</p>
                                        </div>
                                        <div class="card-tools"><em class="card-hint icon ni ni-help-fill" data-toggle="tooltip" data-placement="left" title="Revenue from tips"></em></div>
                                    </div>
                                    <div class="align-end gy-3 gx-5 flex-wrap flex-md-nowrap flex-lg-wrap flex-xxl-nowrap">
                                        <div class="nk-sale-data-group flex-md-nowrap g-4">
                                            <div class="nk-sale-data">
                                                <span class="amount">
                                                    {formatPrice($insights.total_tips_revenue)} <span class="change down text-danger"></span>
                                                </span>
                                                <span class="sub-title">Revenue</span>
                                            </div>
                                            <div class="nk-sale-data">
                                                <span class="amount">
                                                    {formatPrice($insights.total_tips_payout)} <span class="change up text-success"></span>
                                                </span>
                                                <span class="sub-title">Payout</span>
                                            </div>
                                        </div>
                                        <div class="nk-sales-ck sales-revenue"><canvas class="sales-bar-chart" id="tipsRevenue"></canvas></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        {/if}

        <div class="row g-gs">
            <div class="col-lg-6">
                <div class="card card-full">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-4">
                            <div class="card-title">
                                <h6 class="title mb-1">Top Disciplines</h6>
                            </div>
                        </div><!-- .card-title-group -->
                        <div class="d-flex">
                            <ul class="flex-shrink-0 gy-2 mr-3">
                                {foreach $insights['top_disciplines'] as $discipline}
                                    <li class="align-center">
                                        <span class="badge badge-light mr-1">{$discipline.discipline_count}</span>
                                        <span>{$discipline.title}</span>
                                    </li>
                                {/foreach}
                            </ul>
                            <div class="mt-n1 flex-grow-1">
                                <canvas class="course-progress-chart" id="topDisciplines"></canvas>
                            </div>
                            
                        </div><!-- .nk-coin-ovwg -->
                    </div><!-- .card-inner -->
                </div><!-- .card -->
            </div><!-- .col -->

            <div class="col-lg-6">
                <div class="card card-full">
                    <div class="card-inner">
                        <div class="card-title-group align-start">
                            <div class="card-title">
                                <h6 class="title">Top Customers</h6>
                            </div>
                        </div><!-- .card-title-group -->
                    </div>

                    <div class="nk-tb-list mt-n2">
                        <div class="nk-tb-item nk-tb-head">
                            <div class="nk-tb-col"><span>Customer</span></div>
                            <div class="nk-tb-col tb-col-md"><span>Total Orders</span></div>
                            <div class="nk-tb-col"><span>Total Spent</span></div>
                        </div>
                        {foreach $insights['top_customers'] as $customer}
                            <a class="nk-tb-item" href="{$base_uri}/customers/edit/{$customer.customer_id}" data-ajax="/customers/edit/{$customer.customer_id}">
                                <div class="nk-tb-col py-2">
                                    <div class="user-card">
                                        <div class="user-avatar sm bg-purple-dim">
                                            <span>{if $customer.name}{$customer.name[0]|strtoupper}{else}{$customer.email[0]|strtoupper}{/if}</span>
                                        </div>
                                        <div class="user-name">
                                            <span class="tb-lead">{if $customer.name}{$customer.name|capitalize}{else}{$customer.email|strtolower}{/if}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="nk-tb-col tb-col-md py-2">
                                    <span class="tb-sub">{$customer.c_total_orders}</span>
                                </div>
                                <div class="nk-tb-col py-2">
                                    <span class="tb-sub tb-amount">{formatPrice($customer.c_total_spent)}</span>
                                </div>
                            </a>
                        {/foreach}
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-md-6">
                <div class="card h-100">
                    <div class="card-inner">
                        <div class="card-title-group mb-2">
                            <div class="card-title">
                                <h6 class="title">Website Statistics</h6>
                            </div>
                        </div>
                        <ul class="nk-store-statistics">
                            <li class="item">
                                <div class="info">
                                    <div class="title">Orders</div>
                                    <div class="count">{numberFormat($insights.total_orders)}</div>
                                </div>
                                <em class="icon bg-primary-dim ni ni-bag"></em>
                            </li>
                            <li class="item">
                                <div class="info">
                                    <div class="title">Customers</div>
                                    <div class="count">{numberFormat($insights.total_customers)}</div>
                                </div>
                                <em class="icon bg-info-dim ni ni-users"></em>
                            </li>
                            <li class="item">
                                <div class="info">
                                    <div class="title">Employees</div>
                                    <div class="count">{numberFormat($insights.total_employees)}</div>
                                </div>
                                <em class="icon bg-pink-dim ni ni-user-c"></em>
                            </li>
                            <li class="item">
                                <div class="info">
                                    <div class="title">Sales</div>
                                    <div class="count">{formatPrice($insights.total_sales)}</div>
                                </div>
                                <em class="icon bg-purple-dim ni ni-cc-alt"></em>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-lg-5 col-lg-6">
                <div class="card card-full overflow-hidden">
                    <div class="nk-ecwg nk-ecwg4 h-100">
                        <div class="card-inner flex-grow-1">
                            <div class="card-title-group mb-5">
                                <div class="card-title">
                                    <h6 class="title">Orders Statistics</h6>
                                </div>
                            </div>
                            <div class="data-group">
                                <div class="nk-ecwg4-ck">
                                    <canvas class="ecommerce-doughnut-s1" id="ordersStatistics"></canvas>
                                </div>
                                <ul class="nk-ecwg4-legends">
                                    <li>
                                        <div class="title">
                                            <span class="dot dot-lg sq" data-bg="#f9db7b"></span>
                                            <span>Unpaid</span>
                                        </div>
                                        <div class="amount amount-xs">{$insights.statistics.unpaid}</div>
                                    </li>
                                    <li>
                                        <div class="title">
                                            <span class="dot dot-lg sq" data-bg="#8feac5"></span>
                                            <span>In Progress</span>
                                        </div>
                                        <div class="amount amount-xs">{$insights.statistics.progress}</div>
                                    </li>
                                    <li>
                                        <div class="title">
                                            <span class="dot dot-lg sq" data-bg="#6A29FF"></span>
                                            <span>Finished</span>
                                        </div>
                                        <div class="amount amount-xs">{$insights.statistics.finished}</div>
                                    </li>
                                    <li>
                                        <div class="title">
                                            <span class="dot dot-lg sq" data-bg="#f98c45"></span>
                                            <span>Revision</span>
                                        </div>
                                        <div class="amount amount-xs">{$insights.statistics.revision}</div>
                                    </li>
                                    <li>
                                        <div class="title">
                                            <span class="dot dot-lg sq" data-bg="#e85347"></span>
                                            <span>Cancelled</span>
                                        </div>
                                        <div class="amount amount-xs">{$insights.statistics.cancelled}</div>
                                    </li>
                                </ul>
                            </div>
                        </div><!-- .card-inner -->
                    </div>
                </div><!-- .card -->
            </div><!-- .col -->
        </div>
    </div>
{/if}

{if $user.is_writer || $user.is_editor || $user.is_sub_admin}
    <div class="nk-block">
        <div class="row g-gs">

            <div class="col-md-6">
                <div class="card is-dark h-100">
                    <div class="nk-ecwg nk-ecwg1">
                        <div class="card-inner">
                            <div class="card-title-group">
                                <div class="card-title">
                                    <h6 class="title">Total Earned</h6>
                                </div>
                            </div>
                            <div class="data mb-1">
                                <div class="data">
                                    <div class="amount">{formatPrice($insights.total_paid, $writer_currency_format)}</div>
                                    {if !$hasRange}
                                        <div class="info">
                                            <strong>{formatPrice($insights.previous_month_payment, $writer_currency_format)}</strong> in last month
                                        </div>
                                    {/if}
                                </div>
                            </div>
                            {if !$hasRange} 
                                <div class="data">
                                    <h6 class="sub-title">This month so far</h6>
                                    <div class="data-group">
                                        <div class="amount">
                                            {formatPrice($insights.current_month_payment, $writer_currency_format)}
                                        </div>
                                        <div class="info text-right">
                                            <span class="change {if $insights.pct_change_monthly_payment <= 0}down{else}up{/if}">
                                                <em class="icon ni {if $insights.pct_change_monthly_payment <= 0}ni-arrow-long-down{else}ni-arrow-long-up{/if}"></em>{numberFormat($insights.pct_change_monthly_payment)}%
                                            </span><br>
                                            <span>vs. last month</span>
                                        </div>
                                    </div>
                                </div>
                            {/if}
                            <h6 class="sub-title">Earnings over time</h6>
                        </div><!-- .card-inner -->
                        <div class="nk-ecwg2-ck">
                            <canvas class="ecommerce-bar-chart-s1" data-type="amount" id="totalIncome"></canvas>
                        </div>
                    </div><!-- .nk-ecwg -->
                </div><!-- .card -->
            </div><!-- .col --> 

            <div class="col-md-6">
                <div class="card h-100">
                    <div class="nk-ecwg nk-ecwg2">
                        <div class="card-inner">
                            <div class="card-title-group mt-n1">
                                <div class="card-title">
                                    <h6 class="title">Total orders</h6>
                                </div>
                            </div>
                            <div class="data">
                                <div class="amount">{numberFormat($insights.total_orders)}</div>
                                {if !$hasRange}
                                    <div class="info">
                                        <strong>{numberFormat($insights.previous_month_orders)}</strong> in last month
                                    </div>
                                {/if}
                            </div>
                            {if !$hasRange}
                                <div class="data">
                                    <h6 class="sub-title">This month so far</h6>
                                    <div class="data-group">
                                        <div class="amount">
                                            {numberFormat($insights.current_month_orders)}
                                        </div>
                                        <div class="info text-right">
                                            <span class="change {if $insights.pct_change_monthly_orders <= 0}down{else}up{/if}">
                                                <em class="icon ni {if $insights.pct_change_monthly_orders <= 0}ni-arrow-long-down{else}ni-arrow-long-up{/if}"></em>{numberFormat($insights['pct_change_monthly_orders'])}%
                                            </span><br>
                                            <span>vs. last month</span>
                                        </div>
                                    </div>
                                </div>
                            {/if}
                            <h6 class="sub-title">Orders over time</h6>
                        </div><!-- .card-inner -->
                        <div class="nk-ecwg2-ck">
                            <canvas class="ecommerce-bar-chart-s1" id="totalOrders"></canvas>
                        </div>
                    </div><!-- .nk-ecwg -->
                </div><!-- .card -->
            </div><!-- .col -->
        </div>

        <div class="row g-gs">
            <div class="col-xxl-7">
                <div class="row g-gs">
                    <div class="col-lg-6 col-xxl-12">
                        <div class="row g-gs">
                            <div class="col-sm-6 col-lg-12 col-xxl-6">
                                <div class="card">
                                    <div class="nk-ecwg nk-ecwg6">
                                        <div class="card-inner">
                                            <div class="card-title-group">
                                                <div class="card-title">
                                                    <h6 class="title">Outstanding Payment</h6>
                                                </div>
                                            </div>
                                            <div class="data">
                                                <div class="data-group">
                                                    <div class="amount">{formatPrice($insights.outstanding_payment, $writer_currency_format)}</div>
                                                </div>
                                                <div class="info">
                                                    <a href="{$base_uri}/financial-overview/unrequested" data-ajax="/financial-overview/unrequested">Payment Overview</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6 col-lg-12 col-xxl-6">
                                <div class="card">
                                    <div class="nk-ecwg nk-ecwg6">
                                        <div class="card-inner">
                                            <div class="card-title-group">
                                                <div class="card-title">
                                                    <h6 class="title">Last Pay</h6>
                                                </div>
                                            </div>
                                            <div class="data">
                                                <div class="data-group">
                                                    <div class="amount">{formatPrice($insights.last_pay, $writer_currency_format)}</div>
                                                </div>
                                                <div class="info">
                                                    <a href="{$base_uri}/financial-overview/history" data-ajax="/financial-overview/history">Payment History</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                             </div>
                        </div>
                    </div>

                    <div class="col-lg-6 col-xxl-12">
                        <div class="row g-gs">
                            <div class="col-sm-6 col-lg-12 col-xxl-6">
                                {if $tips_enabled}
                                    <div class="card">
                                        <div class="card-inner">
                                            <div class="card-title-group align-start mb-2">
                                                <div class="card-title">
                                                    <h6 class="title">Customer Tips</h6>
                                                </div>
                                                <div class="card-tools"><em class="card-hint icon ni ni-help-fill" data-toggle="tooltip" data-placement="left" title="Income from tips"></em></div>
                                            </div>
                                            <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                                                <div class="nk-sale-data-group flex-md-nowrap g-4">
                                                    <div class="nk-sale-data">
                                                        <span class="amount">
                                                            {formatPrice($insights.total_tips_income)} <span class="change down text-danger"></span>
                                                        </span>
                                                        <span class="sub-title">{$range}</span>
                                                    </div>
                                                </div>
                                                <div class="nk-sales-ck sales-revenue"><canvas class="sales-bar-chart" id="tipsIncome"></canvas></div>
                                            </div>
                                        </div>
                                    </div>
                                {/if}
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>

            {if count($insights['top_disciplines']) >= 5}
                <div class="col-md-6 col-xxl-5">
                    <div class="card card-full">
                        <div class="card-inner">
                            <div class="card-title-group align-start mb-4">
                                <div class="card-title">
                                    <h6 class="title mb-1">Top Disciplines</h6>
                                </div>
                            </div><!-- .card-title-group -->
                            <div class="d-flex">
                                <ul class="flex-shrink-0 gy-2 mr-3">
                                    {foreach $insights['top_disciplines'] as $discipline}
                                        <li class="align-center">
                                            <span class="badge badge-light mr-1">{$discipline.discipline_count}</span>
                                            <span>{$discipline.title}</span>
                                        </li>
                                    {/foreach}
                                </ul>
                                <div class="mt-n1 flex-grow-1">
                                    <canvas class="course-progress-chart" id="topDisciplines"></canvas>
                                </div>
                                
                            </div><!-- .nk-coin-ovwg -->
                        </div><!-- .card-inner -->
                    </div><!-- .card -->
                </div><!-- .col -->
            {/if}
        </div>
    </div>
{/if}
<!-- Admin Charts -->

{if $user.is_admin}
    <script type="text/javascript">
        {if $main_range == 'Custom'}
            var chartLabels = [{", "|implode:$chart['chartLabels'] nofilter}];
        {else}
            var chartLabels = ["{'", "'|implode:$chart['chartLabels'] nofilter}"];
        {/if}

        var totalSales = {
            labels : chartLabels,
            dataUnit : 'Sales',
            lineTension : .3,
            labelType: 'amount',
            datasets : [{
                label : "Sales",
                color : "#9d72ff",
                background : NioApp.hexRGB('#9d72ff',.25),
                data: [{','|implode:$chart['sales_chart']}]
            }]
        }; 

        var totalOrders = {
            labels : chartLabels,
            dataUnit : 'Orders',
            lineTension : .3,
            datasets : [{
                label : "Orders",
                color : "#7de1f8",
                background : NioApp.hexRGB('#7de1f8',.25),
                data: [{','|implode:$chart['orders_chart']}]
            }]
        };

        var topDisciplines = {
            labels: [
                {foreach $insights['top_disciplines'] as $discipline}
                    "{$discipline.title}",
                {/foreach}
            ],
            stacked: true,
            datasets: [{
                label: "Total Orders",
                color: ["#f98c45", "#6baafe", "#8feac5", "#6b79c8", "#79f1dc", "#FF65B6", "#6A29FF", "#79f1dc", "#FF65B6", "#6A29FF"],
                data: [
                    {foreach $insights['top_disciplines'] as $discipline}
                        {$discipline.discipline_count},
                    {/foreach}
                ]
            }]
        };

        var totalCustomers = {
            labels : chartLabels,
            dataUnit : 'Customers',
            lineTension : .3,
            datasets : [{
                label : "Customers",
                color : "#83bcff",
                background : NioApp.hexRGB('#83bcff',.25),
                data: [{','|implode:$chart['customers_chart']}]
            }]
        };

        {if $editor_account_enabled}
            var paymentDatasets = [
                {
                    label : "Writers",
                    color : "#83bcff",
                    background : NioApp.hexRGB('#83bcff',.25),
                    data: [{','|implode:$chart.writer_payments_chart}]
                },
                {
                    label : "Editors",
                    color : "#eb6459",
                    background : NioApp.hexRGB('#eb6459',.25),
                    data: [{','|implode:$chart.editor_payments_chart}]
                }
            ];
        {else}
            var paymentDatasets = [
                {
                    label : "Writers",
                    color : "#83bcff",
                    background : NioApp.hexRGB('#83bcff',.25),
                    data: [{','|implode:$chart.writer_payments_chart}]
                }
            ];
        {/if}

        var totalPayments = {
            labels : chartLabels,
            dataUnit : 'Payment',
            lineTension : .3,
            labelType: 'amount',
            datasets : paymentDatasets
        };

        var ordersStatistics = {
            labels: ["Unpaid", "In Progress", "Finished", "Revision", "Cancelled"],
            dataUnit: 'Orders',
            legend: false,
            datasets: [{
                borderColor: "#fff",
                background: ["#f9db7b", "#8feac5", "#6A29FF", "#f98c45", "#e85347"],
                data: [ {$insights.statistics.unpaid}, {$insights.statistics.progress}, {$insights.statistics.finished}, {$insights.statistics.revision}, {$insights.statistics.cancelled} ]
            }]
        };

        {if $tips_enabled}
            var tipsRevenue = {
                labels : chartLabels,
                dataUnit : 'USD',
                stacked : true,
                datasets : [{
                    label : "Tips Revenue",
                    color : [NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2), NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),"#854fff"],
                    data: [{','|implode:$chart.tips_revenue_chart}]
                }]
            }; 
        {/if}
    </script>
{else}
    <script type="text/javascript">
        {if $main_range == 'Custom'}
            var chartLabels = [{", "|implode:$chart['chartLabels'] nofilter}];
        {else}
            var chartLabels = ["{'", "'|implode:$chart['chartLabels'] nofilter}"];
        {/if}

        var totalIncome = {
            labels : chartLabels,
            dataUnit : 'Sales',
            lineTension : .3,
            labelType: 'amount',
            datasets : [{
                label : "Sales",
                color : "#9d72ff",
                background : NioApp.hexRGB('#9d72ff',.25),
                data: [{','|implode:$chart.income_chart}]
            }]
        }; 

        var totalOrders = {
            labels : chartLabels,
            dataUnit : 'Orders',
            lineTension : .3,
            datasets : [{
                label : "Orders",
                color : "#7de1f8",
                background : NioApp.hexRGB('#7de1f8',.25),
                data: [{','|implode:$chart['orders_chart']}]
            }]
        };

        var topDisciplines = {
            labels: [
                {foreach $insights['top_disciplines'] as $discipline}
                    "{$discipline.title}",
                {/foreach}
            ],
            stacked: true,
            datasets: [{
                label: "Total Orders",
                color: ["#f98c45", "#6baafe", "#8feac5", "#6b79c8", "#79f1dc", "#FF65B6", "#6A29FF", "#79f1dc", "#FF65B6", "#6A29FF"],
                data: [
                    {foreach $insights['top_disciplines'] as $discipline}
                        {$discipline.discipline_count},
                    {/foreach}
                ]
            }]
        };

        {if $tips_enabled}
            var tipsIncome = {
                labels : chartLabels,
                dataUnit : 'USD',
                stacked : true,
                datasets : [{
                    label : "Tips Income",
                    color : [NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2), NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),NioApp.hexRGB("#854fff", .2),"#854fff"],
                    data: [{','|implode:$chart.tips_income_chart}]
                }]
            }; 
        {/if}
    </script>
{/if}

<script type="text/javascript">
    $(document).ready(function($) {
        {if $user.is_admin}
            var range = { 
                "Today": [moment() , moment()], 
                "Yesterday": [moment().subtract(1, 'days') , moment().subtract(1, 'days')], 
                "This_Week": [moment().subtract(6, 'days') , moment()],
                "This_Month": [moment().startOf('month') , moment().endOf('month')],
                "Last_Month": [moment().subtract(1, 'month').startOf('month') , moment().subtract(1, 'month').endOf('month')],
                "This_Year": [moment().subtract(1, 'year').startOf('year') , moment().subtract(1, 'year').endOf('year')]
            }; 
        {else}
            var range = { 
                "This_Month": [moment().startOf('month') , moment().endOf('month')],
                "Last_Month": [moment().subtract(1, 'month').startOf('month') , moment().subtract(1, 'month').endOf('month')],
                "This_Year": [moment().subtract(1, 'year').startOf('year') , moment().subtract(1, 'year').endOf('year')]
            }; 
        {/if}

        {if !empty($range) && in_array($range, array('Today','Yesterday','This Week','This Month','Last Month','This Year'))}
            {if $range == 'Today'}
                var start = range.Today[0];
                var end = range.Today[1];
            {elseif $range == 'Yesterday'}
                var start = range.Yesterday[0];
                var end = range.Yesterday[1];
            {elseif $range == 'This Week'}
                var start = range.This_Week[0];
                var end = range.This_Week[1];
            {elseif $range == 'This Month'}
                var start = range.This_Month[0];
                var end = range.This_Month[1];
            {elseif $range == 'Last Month'}
                var start = range.Last_Month[0];
                var end = range.Last_Month[1];
            {elseif $range == 'This Year'} 
                var start = range.This_Year[0];
                var end = range.This_Year[1];
            {/if}
        {elseif !empty($range) && !empty($start) && !empty($end)}
            var start = "{$start}";
            var end = "{$end}";
        {else}
            var start = range.This_Year[0];
            var end = range.This_Year[1];
        {/if}

        {if $user.is_admin}
            $('#dashboard-daterangepicker').daterangepicker({
                opens: 'left',
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'This Week': [moment().subtract(6, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                }
            });
        {else}
            $('#dashboard-daterangepicker').daterangepicker({
                opens: 'left',
                startDate: start,
                endDate: end,
                ranges: {
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                }
            });
        {/if}
    });

    $(document).on('click', '.ranges ul li', function(event) {
        event.preventDefault();
        if ($(this).attr('data-range-key') != 'Custom Range') {
            $(document).off('click', '.ranges ul li');
            $('#dashboardRedirectLink').attr('href', "/overview?range="+$(this).attr('data-range-key'));
            $('#dashboardRedirectLink').attr('data-ajax', "/overview?range="+$(this).attr('data-range-key'));
            $('#dashboardRedirectLink').click();
        }
    });

    $(document).on('click', '.applyBtn', function(event) {
        event.preventDefault();
        $(document).off('click', '.applyBtn');
        $('#dashboardRedirectLink').attr('href', "/overview?range="+$(this).parent('.drp-buttons').find('.drp-selected').html());
        $('#dashboardRedirectLink').attr('data-ajax', "/overview?range="+$(this).parent('.drp-buttons').find('.drp-selected').html());
        $('#dashboardRedirectLink').click();
    });
        
    $(document).ready(function() {
        proxim.eventEmitter.emit('initializeCharts');
    });
</script>