<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Preference\Discipline;
use Proxim\Preference\PaperType;
use Proxim\Site\Site;
use Proxim\Tools;
use Proxim\Util\DateUtils;

class Oneclick_Updater extends Module
{
    public function __construct()
    {
        $this->name = 'oneclick_updater';
        $this->icon = 'fa fa-sync';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'One Click Updater';
        $this->description = 'Allows you to update all sites with one click';
    }

    function checkStatus($url) {
        $agent = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_8; pt-pt) AppleWebKit/533.20.25 (KHTML, like Gecko) Version/5.0.4 Safari/533.20.27";
    
        // initializes curl session
        $ch = curl_init();
    
        // sets the URL to fetch
        curl_setopt($ch, CURLOPT_URL, $url);
        // sets the content of the User-Agent header
        curl_setopt($ch, CURLOPT_USERAGENT, $agent);
        // make sure you only check the header - taken from the answer above
        curl_setopt($ch, CURLOPT_NOBODY, true);
        // follow "Location: " redirects
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        // return the transfer as a string
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // disable output verbose information
        curl_setopt($ch, CURLOPT_VERBOSE, false);
        // max number of seconds to allow cURL function to execute
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        // execute
        curl_exec($ch);
    
        // get HTTP response code
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
        curl_close($ch);
    
        if ($httpcode >= 200 && $httpcode < 300) {
            return true;
        } else {
            return false;
        }
    }

    public function install()
    {
        $app = $this->application;

        $sites = Site::getSites();
        foreach($sites as $site) {
            Configuration::updateValue('PROX_VERSION', '3.0.0', false, $site['site_id']);
        }

        foreach($sites as $site) {
            $this->checkStatus($site['domain'] . '/updates?force-check=1&key=' . Tools::randomGen());
        }
    }
}