{extends file='dashboard/layout.tpl'}

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            {if $user.is_admin && $sub_view == "listNews"}
                <div class="pull-right flip">
                    <a class="btn btn-primary" href="{$base_uri}/news/publish">
                        <i class="fa fa-plus"></i> Publish News
                    </a>
                </div>
            {/if}

            <i class="fa fa-book mr10"></i>
            <strong>News</strong>
            {if $sub_view == "addNews"}
                &rsaquo; <strong>Publish</strong>
            {elseif $sub_view == "viewNews"}
                &rsaquo; <strong>{$news.id}</strong>
            {/if}
        </div>

        {if $sub_view == "listNews"}

            <div class="card-body">
                {if count($news)}
                    <div class="updates">
                        {foreach $news as $update}
                            <div class="update">
                                <div class="update--container js_news-update {if !$update.is_viewed}new{/if}" data-id="{$update.id}" data-read="{$update.is_viewed}">
                                    <button class="update--toggle" data-toggle="collapse" href="#update-{$update.id}" role="button" aria-expanded="false" aria-controls="update-{$update.id}">
                                        <div class="update--from-to">
                                            <span class="update--sender update--subject__text_collapse">{$update.title}</span>
                                            <span class="message--to">{$update.recipient|ucfirst}</span>
                                        </div>
                                        <div class="update--date">
                                            {if $update.is_viewed}
                                                <span data-toggle="tooltip" data-placement="top" data-title="{$update.read_at}">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16.749" height="11.42" viewBox="0 0 16.749 11.42"><path d="M9.375,7.926a2.284,2.284,0,1,0,2.284,2.284A2.284,2.284,0,0,0,9.375,7.926m0,6.091a3.807,3.807,0,1,1,3.807-3.807,3.807,3.807,0,0,1-3.807,3.807m0-9.517A9,9,0,0,0,1,10.21a9,9,0,0,0,16.749,0A9,9,0,0,0,9.375,4.5Z" transform="translate(-1 -4.5)" fill="#9e9e9e"></path></svg>
                                                </span>
                                            {/if}
                                            <span class="js_moment" data-time="{$update.date_add}">{$update.date_add}</span>
                                        </div>
                                        <div class="update--arrow">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="7.42" viewBox="0 0 12 7.42"><path d="M7.41,8.58,12,13.17l4.59-4.59L18,10l-6,6L6,10Z" transform="translate(-6 -8.58)" fill="#9e9e9e"></path></svg>
                                        </div>
                                    </button>
                                    <div class="update--collapse collapse" id="update-{$update.id}">
                                        <h4 class="update--text">{$update.title}</h4>
                                        <div class="update--text">{$update.content nofilter}</div>

                                        {if $user.is_admin}
                                            <div class="update--buttons">
                                                <a class="btn btn-success" href="/news/viewPost?newsId={$update.id}">
                                                    <i class="fa fa-eye"></i> Edit
                                                </a>
                                                <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="news" data-id="{$update.id}">
                                                    <i class="fa fa-trash-alt"></i> Delete
                                                </a>
                                            </div>
                                        {/if}
                                    </div>
                                </div>
                            </div>
                        {/foreach}

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted">
                        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb10"><strong>No news to show</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $sub_view == "viewNews"}

            <div class="card-body">
                <div class="row">
                    <div class="col-xs-12 col-sm-5 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$news.id}</span>
                                News ID
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$news.recipient|ucfirst}</span>
                                Recipient
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$total_views}</span>
                                Views
                            </li>
                            <li class="list-group-item">
                                <span data-time="{$news.date_add}" class="badge js_moment">{$news.date_add}</span>
                                Published At
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- tabs nav -->
                <ul class="nav nav-tabs mb20">
                    <li class="nav-item">
                        <a href="#info" data-toggle="tab" class="nav-link {if $active_tab == 'info'}active{/if}">
                            <i class="fa fa-info fa-fw mr5"></i><strong class="pr5">Info</strong>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#views" data-toggle="tab" class="nav-link {if $active_tab == 'views'}active{/if}">
                            <i class="fa fa-eye fa-fw mr5"></i><strong class="pr5">Views</strong>
                        </a>
                    </li>
                </ul>
                <!-- tabs nav -->

                <!-- tabs content -->
                <div class="tab-content">

                    <!-- info tab -->
                    <div class="tab-pane {if $active_tab == 'info'}active{/if}" id="info">
                        <form class="js_ajax-forms" data-url="/news/apiPublishNews" autocomplete="off">
                            <input type="hidden" name="news_id" value="{$news.id}">
                            <div class="card-body">
                                <div class="col-md-9 form-horizontal">
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Title</label>
                                        <div class="col-sm-9">
                                            <input class="form-control" name="title" value="{$news.title}">
                                        </div>
                                    </div>
            
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Content</label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control js_summernote" data-height="300" name="content">{$news.content nofilter}</textarea>
                                        </div>
                                    </div>
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Recipient</label>
                                        <div class="col-sm-9">
                                            <select name="recipient" class="form-control">
                                                <option value="all" {if $news.recipient == 'all'}selected{/if}>All</option>
                                                <option value="writers" {if $news.recipient == 'writers'}selected{/if}>Writers</option>
                                                <option value="editors" {if $news.recipient == 'editors'}selected{/if}>Editors</option>
                                                <option value="subadmins" {if $news.recipient == 'subadmins'}selected{/if}>Sub Admins</option>
                                            </select>
                                        </div>
                                    </div>
            
                                    <div class="form-group form-row">
                                        <div class="col-sm-9 offset-3">
                                            <!-- success -->
                                            <div class="alert alert-success mb0 x-hidden"></div>
                                            <!-- success -->
            
                                            <!-- error -->
                                            <div class="alert alert-danger mb0 x-hidden"></div>
                                            <!-- error -->
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            <div class="col-sm-9 text-right">
                                <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                        </form>
                    </div>
                    <!-- info tab -->

                    <!-- views tab -->
                    <div class="tab-pane {if $active_tab == 'views'}active{/if}" id="views">

                        {if count($viewers)}
                            <div class="table-responsive">
                                <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                                    <thead>
                                        <tr>
                                            <th>User</th>
                                            <th>Viewed At</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {foreach $viewers as $viewer}
                                            <tr>
                                                <td>
                                                    <a class="fw-bold" target="_blank" href="{$base_uri}/employees/edit/{$viewer.id}">U{$viewer.id} - {$viewer.first_name} {$viewer.last_name}</a> 
                                                </td>
                                                <td>
                                                    <span class="js_moment" data-time="{$viewer.viewed_at}"></span>
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
            
                                {$views_pager nofilter}
                            </div>
                        {else}
                            <div class="text-center x-muted"> 
                                <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                                <p class="mb10"><strong>No views to show</strong></p>
                            </div>
                        {/if}
                    </div>
                    <!-- views tab -->

                </div>
            </div>

        {elseif $sub_view == "addNews"}
            <form class="js_ajax-forms" data-url="/news/apiPublishNews" autocomplete="off">
                <div class="card-body">
                    <div class="col-md-9 form-horizontal">
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Title</label>
                            <div class="col-sm-9">
                                <input class="form-control" name="title">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Content</label>
                            <div class="col-sm-9">
                                <textarea class="form-control js_summernote" data-height="300" name="content"></textarea>
                            </div>
                        </div>
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Recipient</label>
                            <div class="col-sm-9">
                                <select name="recipient" class="form-control">
                                    <option value="all" selected>All</option>
                                    <option value="writers">Writers</option>
                                    <option value="editors">Editors</option>
                                    <option value="subadmins">Sub Admins</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <div class="col-sm-9 offset-3">
                                <!-- success -->
                                <div class="alert alert-success mb0 x-hidden"></div>
                                <!-- success -->

                                <!-- error -->
                                <div class="alert alert-danger mb0 x-hidden"></div>
                                <!-- error -->
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="card-footer text-right">
                    <div class="col-sm-9">
                        <button type="submit" class="btn btn-primary">Publish</button>
                    </div>
                </div>
            </form>
        {/if}

    </div>
{/block}
