{extends file='dashboard/layout.tpl'}

{block name='content_wrapper'} 
    <div class="{if $sub_view == "listNews"}wide-lg{else}wide-sm{/if}">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title">News
                            {if $sub_view == "viewNews"} &rsaquo; <strong class="text-primary small">{$news.title}</strong>{/if}
                            {if $sub_view == "addNews"} &rsaquo; <strong class="text-primary small">Publish</strong>{/if}
                        </h3>
                    </div>

                    {if $user.is_admin && $sub_view == "listNews"}
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                                <div class="toggle-expand-content" data-content="more-options">
                                    <ul class="nk-block-tools g-3">
                                        <li class="nk-block-tools-opt">
                                            <a href="{$base_uri}/news/publish" data-ajax="/news/publish" class="btn btn-icon btn-primary d-md-none">
                                                <em class="icon ni ni-plus"></em>
                                            </a>
                                            <a href="{$base_uri}/news/publish" data-ajax="/news/publish" class="btn btn-primary d-none d-md-inline-flex">
                                                <em class="icon ni ni-plus"></em><span>Publish News</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- .nk-block-head-content -->
                    {/if}
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        <div class="nk-block">
            {if $sub_view == "listNews"}

                {if count($news)}
                    <div class="updates">
                        {foreach $news as $update}
                            <div class="update mb-2">
                                <div class="update--container js_news-update {if !$update.is_viewed}new{/if}" data-id="{$update.id}" data-read="{$update.is_viewed}">
                                    <button class="update--toggle" data-toggle="collapse" href="#update-{$update.id}" role="button" aria-expanded="false" aria-controls="update-{$update.id}">
                                        <div class="update--from-to">
                                            <span class="update--sender update--subject__text_collapse">{$update.title}</span>
                                            <span class="message--to">{$update.recipient|ucfirst}</span>
                                        </div>
                                        <div class="update--date">
                                            {if $update.is_viewed}
                                                <span data-toggle="tooltip" data-placement="top" data-title="{$update.read_at}">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16.749" height="11.42" viewBox="0 0 16.749 11.42"><path d="M9.375,7.926a2.284,2.284,0,1,0,2.284,2.284A2.284,2.284,0,0,0,9.375,7.926m0,6.091a3.807,3.807,0,1,1,3.807-3.807,3.807,3.807,0,0,1-3.807,3.807m0-9.517A9,9,0,0,0,1,10.21a9,9,0,0,0,16.749,0A9,9,0,0,0,9.375,4.5Z" transform="translate(-1 -4.5)" fill="#9e9e9e"></path></svg>
                                                </span>
                                            {/if}
                                            <span class="js_moment" data-time="{$update.date_add}">{$update.date_add}</span>
                                        </div>
                                        <div class="update--arrow">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="7.42" viewBox="0 0 12 7.42"><path d="M7.41,8.58,12,13.17l4.59-4.59L18,10l-6,6L6,10Z" transform="translate(-6 -8.58)" fill="#9e9e9e"></path></svg>
                                        </div>
                                    </button>
                                    <div class="update--collapse collapse" id="update-{$update.id}">
                                        <h4 class="update--text">{$update.title}</h4>
                                        <div class="update--text">{$update.content nofilter}</div>

                                        {if $user.is_admin}
                                            <div class="update--buttons">
                                                <a class="btn btn-success" href="/news/viewPost?newsId={$update.id}">
                                                    <i class="icon ni ni-eye"></i> <span>Edit</span>
                                                </a>
                                                <a class="btn btn-danger js_deleter" href="javascript:void(0);" data-handle="news" data-id="{$update.id}">
                                                    <i class="icon ni ni-trash-alt"></i> <span>Delete</span>
                                                </a>
                                            </div>
                                        {/if}
                                    </div>
                                </div>
                            </div>
                        {/foreach}

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <h6 class="text-dark title mb-3">No news to show</h6>
                    </div> 
                {/if}

            {elseif $sub_view == "viewNews"}

                <div class="row">
                    <div class="col-xs-12 col-sm-6 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$news.id}</span>
                                News ID
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$news.recipient|ucfirst}</span>
                                Recipient
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$total_views}</span>
                                Views
                            </li>
                            <li class="list-group-item">
                                <span data-time="{$news.date_add}" class="badge js_moment">{$news.date_add}</span>
                                Published At
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="card card-preview">
                    <div class="card-inner">
                        <!-- tabs nav -->
                        <ul class="nav nav-tabs mt-n3">
                            <li class="nav-item">
                                <a href="#info" data-toggle="tab" class="nav-link {if $active_tab == 'info'}active{/if}">
                                    <i class="icon ni ni-info fa-fw mr5"></i><span class="pr5">Info</span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#views" data-toggle="tab" class="nav-link {if $active_tab == 'views'}active{/if}">
                                    <i class="icon ni ni-eye fa-fw mr5"></i><span class="pr5">Views</span>
                                </a>
                            </li>
                        </ul>
                        <!-- tabs nav -->

                        <!-- tabs content -->
                        <div class="tab-content">
                            <!-- info tab -->
                            <div class="tab-pane {if $active_tab == 'info'}active{/if}" id="info">
                                <form class="js_ajax-forms" data-url="/news/apiPublishNews" autocomplete="off">
                                    <input type="hidden" name="news_id" value="{$news.id}">
                                    <div class="form-group">
                                        <label class="control-label">Title</label>
                                        <input class="form-control form-control-lg" name="title" value="{$news.title}">
                                    </div>
            
                                    <div class="form-group">
                                        <label class="control-label">Content</label>
                                        <textarea class="form-control summernote-minimal" data-height="300" name="content">{$news.content nofilter}</textarea>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Recipient</label>
                                        <select name="recipient"  class="form-select" data-search="on" data-ui="lg">
                                            <option value="all" {if $news.recipient == 'all'}selected{/if}>All</option>
                                            <option value="writers" {if $news.recipient == 'writers'}selected{/if}>Writers</option>
                                            <option value="editors" {if $news.recipient == 'editors'}selected{/if}>Editors</option>
                                            <option value="subadmins" {if $news.recipient == 'subadmins'}selected{/if}>Sub Admins</option>
                                        </select>
                                    </div>
            
                                    <div class="form-group">
                                        <!-- success -->
                                        <div class="alert alert-success mb0 x-hidden"></div>
                                        <!-- success -->
        
                                        <!-- error -->
                                        <div class="alert alert-danger mb0 x-hidden"></div>
                                        <!-- error -->
                                    </div>

                                    <div class="text-right mb-0">
                                        <button type="submit" class="btn btn-lg btn-primary">Save Changes</button>
                                    </div>
                                </form>
                            </div>
                            <!-- info tab -->

                            <!-- views tab -->
                            <div class="tab-pane {if $active_tab == 'views'}active{/if}" id="views">

                                {if count($viewers)}
                                    <div class="table-responsive">
                                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                                            <thead>
                                                <tr>
                                                    <th>User</th>
                                                    <th>Viewed At</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                {foreach $viewers as $viewer}
                                                    <tr>
                                                        <td>
                                                            <a class="fw-bold" target="_blank" href="{$base_uri}/employees/edit/{$viewer.id}">U{$viewer.id} - {$viewer.first_name} {$viewer.last_name}</a> 
                                                        </td>
                                                        <td>
                                                            <span class="js_moment" data-time="{$viewer.viewed_at}"></span>
                                                        </td>
                                                    </tr>
                                                {/foreach}
                                            </tbody>
                                        </table>
                    
                                        {$views_pager nofilter}
                                    </div>
                                {else}
                                    <div class="text-center x-muted"> 
                                        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                                        <p class="mb10"><strong>No views to show</strong></p>
                                    </div>
                                {/if}
                            </div>
                            <!-- views tab -->
                        </div>
                    </div>
                </div>

            {elseif $sub_view == "addNews"}
                <form class="card card-preview js_ajax-forms" data-url="/news/apiPublishNews" autocomplete="off">
                    <div class="card-inner">
                        <div class="form-group form-row">
                            <label class="control-label">Title</label>
                            <input class="form-control form-control-lg" name="title">
                        </div>

                        <div class="form-group">
                            <label class="control-label">Content</label>
                            <textarea class="form-control form-control-lg summernote-minimal" data-height="300" name="content"></textarea>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Recipient</label>
                            <select name="recipient" class="form-select" data-search="on" data-ui="lg">
                                <option value="all" selected>All</option>
                                <option value="writers">Writers</option>
                                <option value="editors">Editors</option>
                                <option value="subadmins">Sub Admins</option>
                            </select>
                        </div>

                        <div class="form-group mb-0">
                            <!-- error -->
                            <div class="alert alert-danger alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                            <!-- error -->

                            <!-- success -->
                            <div class="alert alert-success alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                            <!-- success -->
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button type="submit" class="btn btn-primary btn-lg">Publish</button>
                    </div>
                </form>
            {/if}
        </div>
    </div>
{/block}
