<div class="nk-chat border rounded">
    <div class="nk-chat-aside hide-aside">
        <div class="nk-chat-aside-head">
            <div class="nk-chat-aside-user">
                <div class="dropdown">
                    <div class="title fw-bold">Messenger</div>
                </div>
            </div>
        </div>

        <div class="nk-chat-aside-body js_live-messenger-alt">
            <div class="nk-chat-list js_scroller" data-slimScroll-height="100%">
                <ul class="chat-list">
                    {foreach $conversations as $_conversation}
                        {include file=$conversation_tpl_path conversation=$_conversation}
                    {/foreach}
                </ul>

                {if count($conversations) >= $max_results_limit}
                    <!-- see-more -->
                    <button class="d-block btn btn-outline-light bg-white btn-sm js_see-more mt-3 mx-auto" data-get="conversations">
                        <span>See More</span>
                        <div class="loader loader_small x-hidden"></div>
                    </button>
                    <!-- see-more -->
                {/if}
            </div>
        </div>
    </div>

    {if $sub_view == "new"}
        <div class="nk-chat-body show-chat js_conversation-container panel-messages fresh">
            <div class="nk-chat-head">
                <ul class="nk-chat-head-info">
                    <li class="nk-chat-body-close">
                        <a href="#" class="btn btn-icon btn-trigger nk-chat-hide ms-n1">
                            <em class="icon ni ni-arrow-left"></em>
                        </a>
                    </li>
                    <li class="nk-chat-head-user">
                        <h6 class="h6 fw-500">New Message</h6>
                    </li>
                </ul>
            </div> 

            <div class="nk-chat-chat-to">
                <div class="chat-to clearfix js_autocomplete-tags">
                    <div class="to">To:</div>
                    <ul class="tags">
                        {if isset($recipient)}
                            <li data-uid="{$recipient.employee_id}">{$recipient.name}<button type="button" class="close js_tag-remove" title="Remove"><span>×</span></button></li>
                        {/if}
                    </ul>
                    <div class="typeahead">
                        <input type="text" size="1" autofocus data-type="employee">
                    </div>
                </div>
            </div>

            <div class="chat-conversations px-4 py-3 nk-chat-panel js_scroller" data-slimScroll-height="100%">
            </div>

            <div class="chat-attachments attachments clearfix x-hidden">
                <ul>
                    <li class="loading">
                        <div class="progress x-progress"><div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div></div>
                    </li>
                </ul>
            </div>

            <div class="nk-chat-editor">
                <div class="nk-chat-editor-upload  ms-n1">
                    <a href="javascript:void(0);" class="btn btn-sm btn-icon text-primary js_x-uploader" data-handle="chat">
                        <em class="icon ni ni-img-fill"></em>
                    </a>
                    <a href="javascript:void(0);" class="btn btn-sm btn-icon x-form-tools-colors js_chat-colors-menu-toggle js_chat-color-me">
                        <i class="icon ni ni-circle-fill fa-lg fa-fw"></i>
                    </a>
                </div>
                <div class="nk-chat-editor-form">
                    <div class="form-control-wrap">
                        <textarea class="form-control form-control-simple no-resize js_autosize js_post-message" rows="1" placeholder="Type your message..."></textarea>
                    </div>
                </div>
                <ul class="nk-chat-editor-tools g-2">
                    <li>
                        <button class="btn btn-round btn-primary btn-icon js_post-message">
                            <em class="icon ni ni-send-alt"></em>
                        </button>
                    </li>
                </ul>
            </div>
        </div>
    {else}
        {if isset($conversation)}
            {include file=$chat_conversation_tpl_path}
        {else}
            <div class="nk-chat-body show-chat js_conversation-container">
                <div class="text-center text-muted">
                    <img class="mb-3" width="30%" src="{$theme_uri}/images/no_results.png">
                    <p class="my-3 text-bold">No Conversation Selected</p>
                    {if $user.is_admin || $user.is_sub_admin}
                        <a class="btn btn-primary js_chat-new" href="{$base_uri}/messenger?new">
                            <i class="icon fi fi-msg mr5"></i> <span>New Message</span>
                        </a>
                    {/if}
                </div>
            </div>
        {/if}
    {/if}
</div>