<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

use Proxim\ObjectModel;

class Conversation extends ObjectModel
{
    /** @var $id Conversation ID */
    public $id;

    /** @var int last_message_id */
    public $last_message_id;
    
    /** @var string color */
    public $color;

    /** @var string date_upd */
    public $date_upd;

    /** @var string date_add */
    public $date_add;
    
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'conversation',
        'primary' => 'conversation_id',
        'fields' => array(
            'last_message_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'color' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'size' => 32),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
        ),
    );

    public function __construct($id = null)
    {
        parent::__construct($id);
    }
}