<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;

class Mail_Templates extends Module
{
    public function __construct()
    {
        $this->name = 'mail_templates';
        $this->icon = 'fa fa-envelope';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'Mail Templates';
        $this->description = 'Personalize all the emails sent to your customers and employees at every step of the order';
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin ? true : false;
    }

    public function install()
    {
        if (!parent::install()) {
            return false;
        }
    }
}