<!-- Intasend -->
<div class="tab-pane" id="intasend">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fas fa-info-circle fa-2x"></i>
        </div>
        <div class="text">
            To start using Intasend, you'll need to create an account at <a target="_blank" href="https://payment.intasend.com/account/signup">Intasend</a><br>
            Check the documentation for more help
        </div>
    </div>

    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updateIntasendSettings">
        <input type="hidden" name="site_id" value="{$intasendConfiguration.SITE_ID}"/>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Intasend Enabled
            </label>
            <div class="col-sm-9">
                <label class="switch" for="intasend_enabled">
                    <input type="checkbox" name="intasend_enabled" id="intasend_enabled" {if $intasendConfiguration.INTASEND_ENABLED == '1'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Enable payments via Credit Card
                </span>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Default
            </label>
            <div class="col-sm-9">
                <label class="switch" for="default_method_intasend">
                    <input type="checkbox" name="default_method_enabled" id="default_method_intasend" {if $intasendConfiguration.PAYMENT_METHOD_DEFAULT == 'intasend'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Make it the default payment method of the site
                </span>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Intasend Mode
            </label>
            <div class="col-sm-9">
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="intasend_mode" id="intasend_live" {if $intasendConfiguration.INTASEND_MODE == 'live'}checked{/if} value="live">
                    <label for="intasend_live">Live</label>
                </div>
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="intasend_mode" id="intasend_test" {if $intasendConfiguration.INTASEND_MODE == 'test'}checked{/if} value="test">
                    <label for="intasend_test">Test</label>
                    </div>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Public Key</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="intasend_public_key" id="intasend_public_key" maxlength="255" value="{$intasendConfiguration.INTASEND_PUBLIC_KEY}">
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- Intasend -->