<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Site\Site;
use Proxim\Util\ArrayUtils;
use Proxim\Validate;

class Google_Tag_Manager extends Module
{
    const GTM_ANALYTICS_ID = 'GTM_ANALYTICS_ID';
    const GTM_ID = 'GTM_ID';

    public function __construct()
    {
        $this->name = 'google_tag_manager';
        $this->icon = 'fab fa-google';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'Google Tag Manager';
        $this->description = 'Manage and deploy analytics and marketing tags as well as other code snippets.';
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->isLogged() == true;
    }

    public function install()
    {
        if (!parent::install()) {
            return false;
        }

        $this->registerHook([
            'displayAdminEditSiteGeneralTabContent',
            'actionAfterSiteSettingsGeneralUpdate',
            'displayClientHeader'
        ]);
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . PROX_ACTIVE_THEME . '/' . $templateName.'.tpl');
    }

    public function hookDisplayAdminEditSiteGeneralTabContent() {
        $application = $this->application;

        $tagmanagerConfiguration = Configuration::getMultiple([
                self::GTM_ANALYTICS_ID,
                self::GTM_ID
            ],
            $application->site->id
        );

        $this->smarty->assign([
            'tagmanagerConfiguration' => $tagmanagerConfiguration
        ]);
        
        return $this->showTemplate('tab_content');
    }

    public function hookActionAfterSiteSettingsGeneralUpdate( $params ) {
        $site_id = ArrayUtils::get($params, 'site_id');
        $payload = ArrayUtils::get($params, 'payload');

        $site = new Site( (int) $site_id );
        if(Validate::isLoadedObject($site)) {
            Configuration::updateValue(self::GTM_ANALYTICS_ID, ArrayUtils::get($payload, 'gtm_analytics_id'), false, $site->id);
            Configuration::updateValue(self::GTM_ID, ArrayUtils::get($payload, 'gtm_id'), false, $site->id);
        }
    }
}
