<!-- Flutterwave -->
<div class="tab-pane" id="flutterwave">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fa fa-info-circle fa-2x"></i>
        </div>
        <div class="text">
            To start using Flutterwave, you'll need to create an account at <a target="_blank" href="https://flutterwave.com">Flutterwave</a><br>
            Check the documentation for more help
        </div>
    </div>

    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updateFlutterwaveSettings">
        <input type="hidden" name="site_id" value="{$flutterwaveConfiguration.SITE_ID}"/>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Flutterwave Enabled
            </label>
            <div class="col-sm-9">
                <label class="switch" for="flutterwave_enabled">
                    <input type="checkbox" name="flutterwave_enabled" id="flutterwave_enabled" {if $flutterwaveConfiguration.FLUTTERWAVE_ENABLED == '1'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Enable payments via Flutterwave
                </span>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Default
            </label>
            <div class="col-sm-9">
                <label class="switch" for="default_method_enabled">
                    <input type="checkbox" name="default_method_enabled" id="default_method_enabled" {if $flutterwaveConfiguration.PAYMENT_METHOD_DEFAULT == 'flutterwave'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Make it the default payment method of the site
                </span>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Flutterwave Public Key
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="flutterwave_public_key" id="flutterwave_public_key" maxlength="255" value="{$flutterwaveConfiguration.FLUTTERWAVE_KEY}">
            </div>
        </div>

        <div class="form-group">
            <div class="col-sm-9 col-sm-offset-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- Flutterwave -->
