<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Module\PaymentModule;
use Proxim\Site\Site;
use Proxim\Util\ArrayUtils;
use Proxim\Validate;

class Flutterwave extends PaymentModule
{
    /**
    * Flutterwave configuration
    */
    const FLUTTERWAVE_ENABLED = 'FLUTTERWAVE_ENABLED';
    const FLUTTERWAVE_KEY = 'FLUTTERWAVE_KEY';

    public function __construct()
    {
        $this->name = 'flutterwave';
        $this->icon = 'fa fa-credit-card';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';
        $this->displayName = 'Flutterwave';
        $this->description = 'Set up Flutterwave as a payment method on your website';

        $this->bootstrap = true;
        parent::__construct();
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin === true;
    }

    public function install()
    { 
        return parent::install() && 
        $this->registerHook('paymentOptions') &&
        $this->registerHook('verifyPayment') &&
        $this->registerHook('displayClientHeader') &&
        $this->registerHook('displayClientFooter');
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . $templateName.'.tpl');
    }

    public function getContent()
    {
        $application = $this->application;

        $flutterwaveConfiguration = Configuration::getMultiple([
                'PAYMENT_METHOD_DEFAULT',
                self::FLUTTERWAVE_ENABLED,
                self::FLUTTERWAVE_KEY,
                'SITE_ID'
            ],
            $application->site->id
        );

        $this->smarty->assign([
            'flutterwaveConfiguration' => $flutterwaveConfiguration
        ]);

        return $this->getTemplateContent('configure');
    }

    public function updateFlutterwaveSettings() {
        $app = $this->application;
        $payload = $app->request->post();

        $site_id = (int) $app->request->post('site_id');
        if( ArrayUtils::get($payload, 'default_method_enabled') == 'on' ) {
            Configuration::updateValue('PAYMENT_METHOD_DEFAULT', $this->name , false, $site_id);
        }

        Configuration::updateValue(self::FLUTTERWAVE_ENABLED, ArrayUtils::has($payload, 'flutterwave_enabled') ? true : false , false, $site_id);
        Configuration::updateValue(self::FLUTTERWAVE_KEY, ArrayUtils::get($payload, 'flutterwave_public_key'), false, $site_id);

        return $app->sendResponse([
            "success" => true,
			"message" => "System settings have been updated"
        ]);
    }
}