<!-- FasterPays -->
<div class="tab-pane" id="fasterpay">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fas fa-info-circle fa-2x"></i>
        </div>
        <div class="text">
            To start using FasterPay, you'll need to create an account at <a target="_blank" href="https://www.fasterpay.com/">FasterPay</a><br>
            Check the documentation for more help
        </div>
    </div>

    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updateFasterPaySettings">
        <input type="hidden" name="site_id" value="{$fasterPayConfiguration.SITE_ID}"/>
        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">FasterPay Enabled</div> 
                <div class="form-text">Enable payments via FasterPay</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="fasterpay_enabled"> 
                    <input type="checkbox" name="fasterpay_enabled" id="fasterpay_enabled"  {if $fasterPayConfiguration.FASTERPAY_ENABLED == '1'}checked="checked"{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Default</div> 
                <div class="form-text">Make it the default payment method of the site</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="default_method_enabled"> 
                    <input type="checkbox" name="default_method_enabled" id="default_method_enabled" {if $fasterPayConfiguration.PAYMENT_METHOD_DEFAULT == 'fasterpay'}checked="checked"{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>
     
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                FasterPay Mode
            </label>
            <div class="col-sm-9">
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="fasterpay_mode" id="fasterpay_live" {if $fasterPayConfiguration.FASTERPAY_MODE == 'live'}checked{/if} value="live">
                    <label for="fasterpay_live">Live</label>
                </div>
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="fasterpay_mode" id="fasterpay_sandbox" {if $fasterPayConfiguration.FASTERPAY_MODE == 'sandbox'}checked{/if} value="sandbox">
                    <label for="fasterpay_sandbox">Demo</label>    
                </div>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">API Public Key</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="fasterpay_public_key" id="fasterpay_public_key" maxlength="255" value="{$fasterPayConfiguration.FASTERPAY_API_PUBLIC_KEY}">
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">API Private Key</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="fasterpay_private_key" id="fasterpay_private_key" maxlength="255" value="{$fasterPayConfiguration.FASTERPAY_API_PRIVATE_KEY}">
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- FasterPays -->