{if $editorReview}
    <button data-toggle="modal" data-url="#modalEditReview" data-size="small" class="btn btn-secondary">
        <i class="fas fa-star-half-alt fa-fw mr5"></i> Edit Review
    </button>
{else}
    <button data-toggle="modal" data-url="#modalLeaveReview" data-size="small" class="btn btn-success">
        <i class="fas fa-star-half-alt fa-fw mr5"></i> Leave Review
    </button>
{/if}

{strip}
<script type="text/javascript">
{literal}
    $( document ).ready(function() {
        proxim.eventEmitter.on('initializeModal', function(params) {
            if( params[0] == "#modalLeaveReview" || params[0] == '#modalEditReview' ) {
                $("#ratingBox").rating({min:0, max:10, step:1, size:'md'});
            }
        });
    });
{/literal}
</script>
{/strip}

<script id="modalLeaveReview" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/editor_review/postReview" method="POST">
        <input type="hidden" name="order_id" value="{$order.id}">
        <div class="modal-header">
            <h5 class="modal-title">Editor Review</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Rate the quality of the paper received</label>
                <div style="font-size:20px;" class=""></div>
                <input id="ratingBox" name="rating" type="hidden" class="rating" value="0">
            </div>
            <div class="form-group">
                <label class="form-label">Comment</label>
                <textarea class="form-control js_autosize" rows="5" name="comment" required></textarea>
            </div>
            <div class="form-group">
                <label class="form-label">Did you receive your paper on time?</label>
                <div class="selectgroup selectgroup-inline">
                    <label class="selectgroup-item" id="paper_on_time_yes">
                        <input for="paper_on_time_yes" type="radio" name="paper_on_time" value="yes" class="selectgroup-input" required>
                        <span class="selectgroup-button">Yes</span>
                    </label>
                    <label class="selectgroup-item" id="paper_on_time_no">
                        <input for="paper_on_time_no" type="radio" name="paper_on_time" value="no" class="selectgroup-input" required>
                        <span class="selectgroup-button">No</span>
                    </label>
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Submit</button>
        </div>
    </form>
</script>

{if $editorReview}
    <script id="modalEditReview" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/editor_review/postReview" method="POST">
            <input type="hidden" name="order_id" value="{$editorReview.order_id}">
            <input type="hidden" name="rating_id" value="{$editorReview.rating_id}">
            <div class="modal-header">
                <h5 class="modal-title">Editor Review</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Rate the quality of the paper received</label>
                    <div style="font-size:20px;" class=""></div>
                    <input id="ratingBox" name="rating" type="hidden" class="rating" value="{$editorReview.paper_rating}">
                </div>
                <div class="form-group">
                    <label class="form-label">Comment</label>
                    <textarea class="form-control js_autosize" rows="5" name="comment" required>{$editorReview.comment}</textarea>
                </div>
                <div class="form-group">
                    <label class="form-label">Did you receive your paper on time?</label>
                    <div class="selectgroup selectgroup-inline">
                        <label class="selectgroup-item" id="paper_on_time_yes">
                            <input for="paper_on_time_yes" type="radio" name="paper_on_time" value="yes" class="selectgroup-input" required {if $editorReview.paper_on_time == '1'}checked{/if}>
                            <span class="selectgroup-button">Yes</span>
                        </label>
                        <label class="selectgroup-item" id="paper_on_time_no">
                            <input for="paper_on_time_no" type="radio" name="paper_on_time" value="no" class="selectgroup-input" required {if $editorReview.paper_on_time == '0'}checked{/if}>
                            <span class="selectgroup-button">No</span>
                        </label>
                    </div>
                </div>

                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Submit</button>
            </div>
        </form>
    </script>
{/if}