{if $editorReview}
    <li>
        <button data-toggle="modal" data-url="#modalEditReview" data-size="medium" class="btn btn-secondary">
            <i class="icon ni ni-star-half-fill fa-fw mr5"></i> <span>Edit Review</span>
        </button>
    </li>
{else}
    <li>
        <button data-toggle="modal" data-url="#modalLeaveReview" data-size="medium" class="btn btn-secondary">
            <i class="icon ni ni-star-half-fill fa-fw mr5"></i> <span>Leave Review</span>
        </button>
    </li>
{/if}

{strip}
<script type="text/javascript">
{literal}
    $( document ).ready(function() {
        proxim.eventEmitter.on('initializeModal', function(params) {
            if( params[0] == "#modalLeaveReview" || params[0] == '#modalEditReview' ) {
                $("#ratingBox").rating({
                    filledStar: '<i class="icon ni ni-star-fill"></i>',
                    emptyStar: '<i class="icon ni ni-star"></i>',
                    clearButton: '<i class="icon ni ni-minus-sign"></i>',
                    min:0, 
                    max:10, 
                    step:1, 
                    size:'md'
                });
            }
        });
    });
{/literal}
</script>
{/strip}

<script id="modalLeaveReview" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/editor_review/postReview" method="POST">
        <input type="hidden" name="order_id" value="{$order.id}">
        <div class="modal-header">
            <h5 class="modal-title">Editor Review</h5>
            <span class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </span>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Rate the quality of the paper received</label>
                <div style="font-size:20px;" class=""></div>
                <input id="ratingBox" name="rating" type="hidden" class="rating" value="0">
            </div>
            <div class="form-group">
                <label class="form-label">Comment</label>
                <textarea class="form-control js_autosize" rows="5" name="comment" required></textarea>
            </div>
            <div class="form-group">
                <label class="form-label">Did you receive your paper on time?</label>
                <div>
                    <ul class="custom-control-group">
                        <li>
                            <div class="custom-control custom-control-sm custom-radio custom-control-pro checked">
                                <input type="radio" class="custom-control-input" name="paper_on_time" id="paper_on_time_yes" required>
                                <label class="custom-control-label" for="paper_on_time_yes">Yes</label>
                            </div>
                        </li>
                        <li>
                            <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                                <input type="radio" class="custom-control-input" name="paper_on_time" id="paper_on_time_no" required>
                                <label class="custom-control-label" for="paper_on_time_no">No</label>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
            <!-- error -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Submit</button>
        </div>
    </form>
</script>

{if $editorReview}
    <script id="modalEditReview" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/editor_review/postReview" method="POST">
            <input type="hidden" name="order_id" value="{$editorReview.order_id}">
            <input type="hidden" name="rating_id" value="{$editorReview.rating_id}">
            <div class="modal-header">
                <h5 class="modal-title">Editor Review</h5>
                <span class="close" data-dismiss="modal" aria-label="Close">
                    <em class="icon ni ni-cross"></em>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Rate the quality of the paper received</label>
                    <div style="font-size:20px;" class=""></div>
                    <input id="ratingBox" name="rating" type="hidden" class="rating" value="{$editorReview.paper_rating}">
                </div>
                <div class="form-group">
                    <label class="form-label">Comment</label>
                    <textarea class="form-control js_autosize" rows="5" name="comment" required>{$editorReview.comment}</textarea>
                </div>
                <div class="form-group">
                    <label class="form-label">Did you receive your paper on time?</label>
                    <div>
                        <ul class="custom-control-group">
                            <li>
                                <div class="custom-control custom-control-sm custom-radio custom-control-pro checked">
                                    <input type="radio" class="custom-control-input" name="paper_on_time" value="yes" id="paper_on_time_yes" required {if $editorReview.paper_on_time == '1'}checked{/if}>
                                    <label class="custom-control-label" for="paper_on_time_yes">Yes</label>
                                </div>
                            </li>
                            <li>
                                <div class="custom-control custom-control-sm custom-radio custom-control-pro">
                                    <input type="radio" class="custom-control-input" name="paper_on_time" value="no" id="paper_on_time_no" required {if $editorReview.paper_on_time == '0'}checked{/if}>
                                    <label class="custom-control-label" for="paper_on_time_no">No</label>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden"><em class="icon ni ni-check-circle"></em> <span></span></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Submit</button>
            </div>
        </form>
    </script>
{/if}