{if $user.is_admin || $user.is_sub_admin || $user.is_writer}
    <div class="oinfo__data-item">
        <div class="oinfo__data-col">
            <span class="oinfo__data-label">Fines:</span>
            <span class="oinfo__data-value">
                <div class="d-flex align-items-center">
                    <span class="text-danger text-lg">{if $fine_amount}{formatPrice($fine_amount)}{else}{formatPrice(0)}{/if}</span>
                    <div class="ml-auto mr0">
                        {if $user.is_admin || $user.is_sub_admin}
                            <button data-toggle="modal" data-url="#modalChargeFine" data-size="small" class="btn btn-primary ml-auto">
                                <i class="icon ni ni-wallet-out"></i> <span>Charge Fine</span>
                            </button>
                        {/if}
                    </div>
                </div>

                <div class="mt-3">
                    {foreach $charged_fines as $charged_fine}
                        <div class="row m-0 rounded mb-2">
                            <div class="{if $user.is_admin || $user.is_sub_admin}col-md-7{else}col-md-10{/if} p-2 bg-primary-dim fw-bold d-flex align-items-center rounded-left">
                                {$charged_fine.description}
                            </div>
                            <div class="{if $user.is_admin || $user.is_sub_admin}col-md-2{else}col-md-2{/if} p-2 bg-danger-dim fw-bold d-flex align-items-center">
                                {formatPrice($charged_fine.amount)}
                            </div>

                            {if $user.is_admin || $user.is_sub_admin}
                                <div class="col-md-3 p-2 bg-primary-dim fw-bold text-white rounded-right d-flex">
                                    <button data-toggle="modal" data-url="#modalEditPenalty" data-size="small" data-options='{$charged_fine|json_encode nofilter}' class="btn btn-outline-light bg-white ml-auto">
                                        <i class="icon ni ni-edit"></i> <span>Edit Fee</span>
                                    </button>
                                </div>
                            {/if}
                        </div>
                    {/foreach}
                </div>
            </span>
        </div>
    </div>

    <!-- Charge Fine -->
    <script id="modalChargeFine" type="text/template" autocomplete="off">
        <form class="js_ajax-forms p0 m0" data-url="/creditfine/chargeFine" method="POST">
            <input type="hidden" name="order_id" value="{$order_id}"/>
            <div class="modal-header">
                <h5 class="modal-title">Charge Fine</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Fine</label>
                    <select class="form-select" data-ui="lg" name="fine_id">
                        <option value="-1" selected="" disabled>Select the fine</option>
                        {foreach $fines as $fine}
                            <option value="{$fine.fine_type_id}">{$fine.name} - {if $fine.type == 'amount'}{formatPrice($fine.value)}{else}{numberFormat($fine.value, 0)}%{/if}</option>
                        {/foreach}
                    </select>

                </div>

                <div class="form-group">
                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Charge Fine</button>
            </div>
        </form>
    </script>
    <!-- Charge Fine -->

    <!-- Order Edit Penalty -->
    <script id="modalEditPenalty" type="text/template" autocomplete="off">
        <form class="js_ajax-forms p0 m0" data-url="/creditfine/updateOrderPenalty" method="POST">
            <input type="hidden" name="credit_fine_id" value="{literal}{{credit_fine_id}}{/literal}"/>
            <div class="modal-header">
                <h5 class="modal-title">Edit Penalty</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label">Penalty Fee</label>
                    <input name="amount" class="form-control form-control-lg force-integer" value="{literal}{{amount}}{/literal}"/>
                </div>

                <div class="form-group">
                    <!-- error -->
                    <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                    <!-- error -->

                    <!-- success -->
                    <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                    <!-- success -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
            </div>
        </form>
    </script>
    <!-- Order Edit Penalty -->
{/if}