{if count($rows)}
    <table class="table table-tranx is-compact mb-0">
        <thead>
            <tr class="tb-tnx-head">
                <th class="tb-tnx-info">Type</th>
                <th class="tb-tnx-info">Order ID</th>
                <th class="tb-tnx-info">Amount</th>
                <th class="tb-tnx-info">Resolved</th>
                <th class="tb-tnx-info">Date</th>
                <th class="tb-tnx-info">Actions</th>
            </tr>
        </thead>
        <tbody>
            {foreach $rows as $row}
                <tr class="tb-tnx-item">
                    <td class="tb-tnx-info">{$row.type|ucfirst}</td>
                    <td class="tb-tnx-info fw-bold">
                        {if $row.order_id}
                            <a href="{$base_uri}/order/{$row.order_id}" data-ajax="/order/{$row.order_id}" class="text-link">#{$row.order_id}</a>
                        {else}
                            N/A
                        {/if}
                    </td>
                    <td class="tb-tnx-info">
                        <span class="text-dark fw-bold">{formatPrice($row.amount)}</span>
                    </td>
                    <td class="tb-tnx-info">
                        <span class="badge badge-dot {if $row.resolved}badge-success{else}badge-danger{/if}">{if $row.resolved}<span class="js_moment" data-time="{$row.resolved_at}">{$row.resolved_at}</span>{else}No{/if}</span>
                    </td>
                    <td class="tb-tnx-info">
                        <span class="js_moment" data-time="{$row.date_add}">{$row.date_add}</span>
                    </td>
                    <td class="tb-tnx-info">
                        <button data-toggle="modal" data-url="#viewCFDetails" data-options='{$row|json_encode nofilter}' data-size="small" class="btn btn-xs btn-primary">
                            <i class="icon ni ni-eye"></i> <span>View</span>
                        </button>
                    </td>
                </tr>
            {/foreach}
        </tbody>
    </table>

    <div class="nk-block-between-md g-3">
        <div class="g">
            {$pager nofilter}
        </div>
    </div><!-- .nk-block-between -->
{else}
    <div class="text-center x-muted py-5">
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <h6 class="text-dark title mb-3">The list is empty</h6>
    </div>
{/if}

<script id="viewCFDetails" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">View Details</h5>
        <span class="modal-close" data-dismiss="modal" aria-label="Close">
            <i class="icon ni ni-times"></i>
        </span>
    </div>
    <div class="modal-body">
        <div>{literal}{{description}}{/literal}</div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    </div>
</script>