<p class="card-description">The backup facility creates database snapshots in the <code>content/backup</code> folder of your proxim installation. These backups are named in according to the date and time the backup was taken. The compression level goes from 0 (no compression) to 9 (maximum compression). Higher compression requires more processing and may not result in much space savings.</p>
<p>Database name <strong>{DB_NAME}</strong></p>
<p>Database prefix <strong>{DB_PREFIX}</strong></p>

<div class="row">
    <div class="col-md-6 grid-margin">
    
        <form class="js_ajax-forms mb10" data-url="/backup_restore/createBackup" method="POST">
            <input type="hidden" name="request" value="backup">
            <div class="form-group">
                <label class="form-label">Compression level?</label>
                <select class="form-control custom-select" name="compress">
                    <option value="0" selected="">0</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                    <option value="5">5</option>
                    <option value="6">6</option>
                    <option value="7">7</option>
                    <option value="8">8</option>
                    <option value="9">9</option>
                </select>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->

            <button data-toggle="tooltip" data-placement="top" data-original-title="Backup the tables in your database." type="submit" class="btn btn-success mt-4" name="backup">Backup the Database</button>
        </form>

        {if count($backup_files)}
            <div class="alert alert-warning mb5">
                <strong>Note:</strong> Each database table is emptied before the restore is attempted. After a successful restore the database will be in the same state as when the backup was created.
            </div>

            <form id="restore_database" class="js_ajax-forms mt10" data-url="/backup_restore/restoreBackup" method="POST">
                <input type="hidden" name="request" value="restore">
                <div class="form-group">
                    <label class="form-label">Select the database restore file</label>                     
                    <select class="form-control custom-select" id="backupfile" name="backupfile">
                        {foreach $backup_files as $bfile}
                            <option value="{$bfile}">{$bfile}</option>
                        {/foreach}
                    </select>
                </div>
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
                <button data-toggle="tooltip" data-placement="top" data-original-title="Restore the tables in your database from a previous backup." type="button" class="btn btn-danger mt-4 js_restore-database" name="restore">Restore the database</button>
            </form>
        {/if}
        
    </div>
</div>

{block name='javascript_bottom'}
    <script type="text/javascript">
    $( document ).ready(function() {
        $( "#restore_button" ).click(function() {
            if(!confirm('Do you really want to restore the database? Restoring the wrong backup might result in data loss!')) {
                return false;
            };
        });

        // run database restore
        $(document).on('click', '.js_restore-database', function () {
            confirm("Restore Database", "Do you really want to restore the database? Restoring the wrong backup might result in data loss!", function() {
                $( '.modal' ).modal( 'hide' ).data( 'bs.modal', null );
                $('#restore_database').submit();
            });
        });
    });
    </script>
{/block}