<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Preference\Deadline;
use Proxim\Preference\Discipline;
use Proxim\Preference\PaperType;
use Proxim\Site\Site;
use Proxim\Util\DateUtils;

class Articlewriting extends Module
{
    public function __construct()
    {
        $this->name = 'articlewriting';
        $this->icon = 'fas fa-newspaper';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'Article Writing';
        $this->description = 'Offer article writing services to your customers';
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin ? true : false;
    }

    public function uninstall()
    {
        $sites = Site::getSites();

        foreach($sites as $site) {
            Configuration::updateValue('ARTICLE_WRITING_ENABLED', false , false, $site['site_id']);
        }

        if (!parent::uninstall()) {
            return false;
        }
    }

    public function install()
    {

        try {
            $englishTypes = array(
                'English US',
                'English UK'
            );
            
            foreach($englishTypes as $englishType) {
                $englishTypeId = (int) Db::getInstance()->getValue('SELECT english_type_id FROM ' . Db::prefix('english_type') . ' WHERE title =  \'' . pSQL($englishType) . '\'');
                if($englishTypeId) {
                    Db::getInstance()->update(
                        'english_type',
                        array(
                            'title' => $englishType,
                            'date_upd' => DateUtils::now()
                        ),
                        'english_type_id = ' . (int) $englishTypeId
                    );
                } else {
                    Db::getInstance()->insert(
                        'english_type',
                        array(
                            'title' => $englishType,
                            'date_upd' => DateUtils::now(),
                            'date_add' => DateUtils::now(),
                        )
                    );
                }
            }
            
        } catch (\Exception $e) {
        
        }
        
        
        try {
            $targetAudiences = array(
                'Businesses',
                'General Audience'
            );
            
            foreach($targetAudiences as $targetAudience) {
                $targetAudienceId = (int) Db::getInstance()->getValue('SELECT target_audience_id FROM ' . Db::prefix('target_audience') . ' WHERE title =  \'' . pSQL($targetAudience) . '\'');
                if($targetAudienceId) {
                    Db::getInstance()->update(
                        'target_audience',
                        array(
                            'title' => $targetAudience,
                            'date_upd' => DateUtils::now()
                        ),
                        'target_audience_id = ' . (int) $targetAudienceId
                    );
                } else {
                    Db::getInstance()->insert(
                        'target_audience',
                        array(
                            'title' => $targetAudience,
                            'date_upd' => DateUtils::now(),
                            'date_add' => DateUtils::now(),
                        )
                    );
                }
            }
            
        } catch (\Exception $e) {
        
        }
        
        try {
            $writingTones = array(
                [
                    'title' => 'Informal',
                    'description' => 'Informal, chatty, and familiar'
                ],
                [
                    'title' => 'Formal',
                    'description' => 'Corporate tone that\'s all business'  
                ],
                [
                    'title' => 'Business Casual',
                    'description' => 'Friendly with a professional tone'
                ]
            );
            
            foreach($writingTones as $writingTone) {
                $writingToneId = (int) Db::getInstance()->getValue('SELECT writing_tone_id FROM ' . Db::prefix('writing_tone') . ' WHERE title =  \'' . pSQL($writingTone['title']) . '\'');
                if($writingToneId) {
                    Db::getInstance()->update(
                        'writing_tone',
                        array(
                            'title' => $writingTone['title'],
                            'description' => $writingTone['description'],
                            'date_upd' => DateUtils::now()
                        ),
                        'writing_tone_id = ' . (int) $writingToneId
                    );
                } else {
                    Db::getInstance()->insert(
                        'writing_tone',
                        array(
                            'title' => $writingTone['title'],
                            'description' => $writingTone['description'],
                            'date_upd' => DateUtils::now(),
                            'date_add' => DateUtils::now(),
                        )
                    );
                }
            }
        } catch (\Exception $e) {
        
        }
        
        try {
            $writingStyles = array(
                [
                    'title' => 'Informational',
                    'description' => 'Entirely impartial and purely informational content'
                ],
                [
                    'title' => 'Promotional',
                    'description' => 'Content that overtly promotes your products or services'
                ]
            );
            
            foreach($writingStyles as $writingStyle) {
                $writingStyleId = (int) Db::getInstance()->getValue('SELECT writing_style_id FROM ' . Db::prefix('writing_style') . ' WHERE title =  \'' . pSQL($writingStyle['title']) . '\'');
                if($writingStyleId) {
                    Db::getInstance()->update(
                        'writing_style',
                        array(
                            'title' => $writingStyle['title'],
                            'description' => $writingStyle['description'],
                            'date_upd' => DateUtils::now()
                        ),
                        'writing_style_id = ' . (int) $writingStyleId
                    );
                } else {
                    Db::getInstance()->insert(
                        'writing_style',
                        array(
                            'title' => $writingStyle['title'],
                            'description' => $writingStyle['description'],
                            'date_upd' => DateUtils::now(),
                            'date_add' => DateUtils::now(),
                        )
                    );
                }
            }
        } catch (\Exception $e) {
        
        }
        
        try {
            $contentFeels = array(
                [
                    'title' => 'Evergreen',
                    'description' => 'Long lasting content that feels "current" all year round'
                ],
                [
                    'title' => 'Newsy',
                    'description' => 'Mentions current events, but feels dated after a while'  
                ]
            );
            
            foreach($contentFeels as $contentFeel) {
                $contentFeelId = (int) Db::getInstance()->getValue('SELECT content_feel_id FROM ' . Db::prefix('content_feel') . ' WHERE title =  \'' . pSQL($contentFeel['title']) . '\'');
                if($contentFeelId) {
                    Db::getInstance()->update(
                        'content_feel',
                        array(
                            'title' => $contentFeel['title'],
                            'description' => $contentFeel['description'],
                            'date_upd' => DateUtils::now()
                        ),
                        'content_feel_id = ' . (int) $contentFeelId
                    );
                } else {
                    Db::getInstance()->insert(
                        'content_feel',
                        array(
                            'title' => $contentFeel['title'],
                            'description' => $contentFeel['description'],
                            'date_upd' => DateUtils::now(),
                            'date_add' => DateUtils::now(),
                        )
                    );
                }
                
            }
            
        } catch (\Exception $e) {
        
        }

        $contentTypes = array(
            'Blog Post',
            'Article',
            'Product Description',
            'Product Review',
            'Web Page',
            'Press Release',
            'Email Copywriting',
            'Misc'
        );

        foreach($contentTypes as $contentType) {
            $contentTypeId = (int) Db::getInstance()->getValue('SELECT paper_type_id FROM ' . Db::prefix('paper_type') . ' WHERE title =  \'' . pSQL($contentType) . '\' AND is_article_writing = 1');
            if($contentTypeId) {
                Db::getInstance()->update(
                    'paper_type',
                    array(
                        'title' => $contentType,
                        'is_article_writing' => true
                    ),
                    'paper_type_id = ' . (int) $contentTypeId
                );
            } else {
                $paperType = new PaperType();
                $paperType->title = $contentType;
                $paperType->is_article_writing = 1;
                $paperType->add();
            }
        }

        $categories = array(
            'Accounting & Finance',
            'Automotive',
            'Beauty',
            'Business',
            'Construction',
            'E-commerce',
            'Education',
            'Entertainment & Gaming',
            'Fashion',
            'Fitness',
            'Food & Nutrition',
            'Garden & Landscaping',
            'Healthcare & Medical',
            'Home Repair & Home Maintenance',
            'Hospitality',
            'Human Resources',
            'Insurance',
            'Interior Decoration',
            'IT',
            'Legal',
            'Marketing & Advertising',
            'Non-profit',
            'Pets',
            'Photography',
            'Property Management',
            'Real Estate (Commercial)',
            'Real Estate (Residential)',
            'Retail',
            'Security',
            'Senior Services',
            'SEO',
            'Software Development',
            'Solar Power',
            'Sustainability',
            'Transportation & Logistics',
            'Travel & Tourism',
            'Veterinary',
            'Web Design'
        );

        foreach($categories as $category) {
            $categoryId = (int) Db::getInstance()->getValue('SELECT discipline_id FROM ' . Db::prefix('discipline') . ' WHERE title =  \'' . pSQL($category) . '\' AND is_article_writing = 1');
            if($categoryId) {
                Db::getInstance()->update(
                    'discipline',
                    array(
                        'title' => $category,
                        'is_article_writing' => true
                    ),
                    'discipline_id = ' . (int) $categoryId
                );
            } else {
                $discipline = new Discipline();
                $discipline->title = $category;
                $discipline->is_complex_assignment = false;
                $discipline->is_academic_writing = false;
                $discipline->is_calculations = false;
                $discipline->is_programming = false;
                $discipline->is_article_writing = true;
                $discipline->add();
            }
        }

        $deadlines = array(
            [
                'name' => '12 Hours',
                'hrs_customer' => 12,
                'hrs_writer' => 10,
                'price_per_word' => 0.021	
            ],
            [
                'name' => '24 Hours',
                'hrs_customer' => 24,
                'hrs_writer' => 20,
                'price_per_word' => 0.019
            ],
            [
                'name' => '48 Hours',
                'hrs_customer' => 48,
                'hrs_writer' => 40,
                'price_per_word' => 0.016
            ],
            [
                'name' => '3 Days',
                'hrs_customer' => 72,
                'hrs_writer' => 65,
                'price_per_word' => 0.013
            ],
            [
                'name' => '5 Days',
                'hrs_customer' => 120,
                'hrs_writer' => 100,
                'price_per_word' => 0.010
            ],
            [
                'name' => '7 Days',
                'hrs_customer' => 168,
                'hrs_writer' => 125,
                'price_per_word' => 0.009
            ]
        );

        $sites = Site::getSites();

        foreach($sites as $site) {
            Configuration::updateValue('ARTICLE_WRITING_ENABLED', true , false, $site['site_id']);
            
            foreach($deadlines as $deadline) {
                $deadlineId = (int) Db::getInstance()->getValue('SELECT deadline_id FROM ' . Db::prefix('deadline') . ' WHERE hrs_customer = ' . (int) $deadline['hrs_customer'] . ' AND site_id = ' . (int) $site['site_id'] . ' AND is_article_writing = 1' );
                $insert = true;
                if($deadlineId) {
                    $siteDeadline = new Deadline( $deadlineId );
                    $insert = false;
                } else {
                    $siteDeadline = new Deadline();
                }
                    
                $siteDeadline->site_id = $site['site_id'];
                $siteDeadline->is_article_writing = true;
                $siteDeadline->name = $deadline['name'];
                $siteDeadline->price_per_page = (float) $deadline['price_per_word'];
                $siteDeadline->hrs_customer = $deadline['hrs_customer'];
                $siteDeadline->hrs_writer = $deadline['hrs_writer'];

                if($insert) {
                    $siteDeadline->add();
                } else {
                    $siteDeadline->update();
                }
            }
        }

        if (!parent::install()) {
            return false;
        }
    }
}