<form method="GET" class="mb20" autocomplete="off">
    <input type="hidden" name="page" value="{$selected_page}"/>
    <div class="row">
        <div class="form-group col-md-4">
            <input type='text' class="form-control" placeholder="Search User ID, IP or Event Type" value="{$query}" name="query" />
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="from" data-target-input="nearest">
                <input type='text' class="form-control date-time-picker" placeholder="From" value="{$date_from}" data-target="#from" name="from" />
                <div class="input-group-append" data-target="#from" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="icon ni ni-calendar"></i></span>
                </div>
            </div> 
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="to" data-target-input="nearest">
                <input type='text' class="form-control date-time-picker" placeholder="To" value="{$date_to}" data-target="#to" name="to" />
                <div class="input-group-append" data-target="#to" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="icon ni ni-calendar"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group col-md-2">
            <button type="submit" name="search" class="btn btn-primary">
                <i class="icon ni ni-search mr5"></i> <span>Search</span>
            </button>
        </div>
    </div>
</form> 

{if count($activities)}
    <div class="card">
        <div class="card-inner-group">
            <div class="card-inner p-0">
                <table class="table table-ulogs">
                    <thead class="table-light">
                        <tr>
                            <th>User</th>
                            <th>IP Address</th>
                            <th>Object</th>
                            <th>Event Type</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $activities as $activity}
                            <tr>
                                <td>
                                    {if $activity.user_object == 'employee'}
                                        <a class="text-primary fw-bold" href="{$base_uri}/employees/edit/{$activity.user_id}" data-ajax="/employees/edit/{$activity.user_id}">{$activity.name|ucwords}</a>
                                    {else}
                                        <a class="text-primary fw-bold" href="{$base_uri}/customers/edit/{$activity.user_id}" data-ajax="/customers/edit/{$activity.user_id}">{$activity.name|ucwords}</a>
                                    {/if}
                                </td>
                                <td>
                                    <span class="sub-text">{$activity.user_ip}</span>
                                </td>
                                <td>
                                    <span class="sub-text">{$activity.object|ucfirst} | #{$activity.object_id}</span>
                                </td>
                                <td>
                                    <span class="sub-text">{$activity.event|strtolower}</span>
                                </td>
                                <td>
                                    <span class="js_moment" data-time="{$activity.date_add}">{$activity.date_add}</span>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>

            <div class="card-inner">
                {$pager nofilter}
            </div>
        </div>
    </div>
{else}
    <div class="text-center py-5"> 
        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
        <h6 class="text-dark title mb-3">No activities to show</h6>
    </div>
{/if}